/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.
//
// And then further adapted to optimise it somewhat.  The improvement, while not
// huge, made a noticable difference with one of my more complex scenes. TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// Found this on GLSL sandbox. I really liked it, changed a few things and made
// it tileable. :) // by David Hoskins.

// -----------------------------------------------------------------------
// Water turbulence effect by joltz0r 2013-07-04, improved 2013-07-07
// Rewritten June 2015 by TheEmu
// -----------------------------------------------------------------------

// Redefine below to see the tiling - primarily for debugging.
// #define SHOW_TILING

#define TAU 6.28318530718 // 2*Pi

const vec3  waterColour = vec3(0.0,0.35,0.5);
const float inten = 0.005;

void main( void ) 
{
   float time = iGlobalTime * 0.5 + 23.0;
   vec2 uv = gl_FragCoord.xy / iResolution.xy;
    
#ifdef SHOW_TILING
   vec2 p = mod(uv*2.0*TAU,TAU) - 250.0;
#else
   vec2 p = mod(uv*TAU,TAU)     - 250.0;
#endif

   const float k0 = 3.5;
   const float k1 = ( 1.0 - k0     );
   const float k2 = ( 1.0 - k0/2.0 );
   const float k3 = ( 1.0 - k0/3.0 );
   const float k4 = ( 1.0 - k0/4.0 );
   const float k5 = ( 1.0 - k0/5.0 );

   float t1 = time * ( 1.0 - k1 );
   float t2 = time * ( 1.0 - k2 );
   float t3 = time * ( 1.0 - k3 );
   float t4 = time * ( 1.0 - k4 );
   float t5 = time * ( 1.0 - k5 );

   vec2 q = vec2(p);
   vec2 r = p * inten;

   vec2 a1=t1-q, b1=t1+q; vec2 s1=sin(b1), c1=cos(b1);
   q = p + vec2 ( cos(a1.x)+s1.y, sin(a1.y)+c1.x );

   vec2 a2=t2-q, b2=t2+q; vec2 s2=sin(b2), c2=cos(b2);
   q = p + vec2 ( cos(a2.x)+s2.y, sin(a2.y)+c2.x );

   vec2 a3=t3-q, b3=t3+q; vec2 s3=sin(b3), c3=cos(b3);
   q = p + vec2 ( cos(a3.x)+s3.y, sin(a3.y)+c3.x );

   vec2 a4=t4-q, b4=t4+q; vec2 s4=sin(b4), c4=cos(b4);
   q = p + vec2 ( cos(a4.x)+s4.y, sin(a4.y)+c4.x );

   vec2 a5=t5-q, b5=t5+q; vec2 s5=sin(b5), c5=cos(b5);
   q = p + vec2 ( cos(a5.x)+s5.y, sin(a5.y)+c5.x );

   float c = 1.0
           + 1.0 / length ( r / vec2 ( s1.x, c1.y ) )
           + 1.0 / length ( r / vec2 ( s2.x, c2.y ) )
           + 1.0 / length ( r / vec2 ( s3.x, c3.y ) )
           + 1.0 / length ( r / vec2 ( s4.x, c4.y ) )
           + 1.0 / length ( r / vec2 ( s5.x, c5.y ) );

   c = 1.17 - pow ( c*0.2, 1.4 );

   vec3 colour =  clamp ( pow(abs(c),8.0) + waterColour, 0.0, 1.0 );
    
   #ifdef SHOW_TILING
      vec2 pixel = 2.0 / iResolution.xy;
      uv *= 2.0;
      float f = floor(mod(iGlobalTime*0.5,2.0)); // Flash value.
      vec2 first = step(pixel,uv) * f;           // Rule out first screen pixels and flash.
      uv = step(fract(uv),pixel);                // Add one line of pixels per tile.
      colour = mix(colour,vec3(1.0,1.0,0.0),(uv.x+uv.y)*first.x*first.y); // Yellow line
   #endif

   gl_FragColor = vec4(colour,1.0);

}